% (C) 2001-2021 Intel Corporation. All rights reserved.
% Your use of Intel Corporation's design tools, logic functions and other 
% software and tools, and its AMPP partner logic functions, and any output 
% files from any of the foregoing (including device programming or simulation 
% files), and any associated documentation or information are expressly subject 
% to the terms and conditions of the Intel Program License Subscription 
% Agreement, Intel FPGA IP License Agreement, or other applicable 
% license agreement, including, without limitation, that your use is for the 
% sole purpose of programming logic devices manufactured by Intel and sold by 
% Intel or its authorized distributors.  Please refer to the applicable 
% agreement for further details.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Altera NCO Compiler version 2.0
% file : "+var_name+"_tb.m
%
% Description : The following Matlab testbench excercises the NCO model "+varname+".m
% generated by Altera's NCO Compiler Megacore
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameter description
% N : the length of input and output arrays generated by the model
N=5000;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Input arrays

% phi_inc_i : input phase increment : Length N (required)
phi_inc_i = (2^18).*ones(1,N);
% freq_mod_i : frequency modulation input : Length N (optional)
freq_mod_i = [zeros(1,N/4),2^18.*ones(1,3*N/4)];
freq_mod_i = zeros(1,N);
% phase_mod_i : frequency modulation input : Length N (optional)
phase_mod_i = [zeros(1,N/2),2^16.*ones(1,N/2)];
phase_mod_i = zeros(1,N);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function call to generated nco function 
[sin_out,cos_out] = ncogen(phi_inc_i,phase_mod_i,freq_mod_i);

figure,stairs(sin_out),grid on,zoom on;
hold on, stairs(cos_out,'r');
legend('sine','cosine');